<?php 
session_start();

include("../../../sql_connect.php");
include("functions.php");

$user_data = check_login($dbc);

function build_url($params = []) {
    $base_url = "codex.php";
    $query = array_merge($_GET, $params); // Merge new params with existing ones
    return $base_url . '?' . http_build_query($query);
}

$search = isset($_GET['search']) ? trim(mysqli_real_escape_string($dbc, $_GET['search'])) : '';

$order = isset($_GET['order']) ? $_GET['order'] : 'n';
switch ($order) {
    case "n":
        $sort = "`NAME`";
        break;
    case "rd":
        $sort = "`RELEASE_DATE`";
        break;
    case "rot":
        $sort = "`RELEASE_ORDER_OF_TYPE`";
        break;
    default:
        $sort = "`NAME`";
        break;
}

$current_dir = $_GET['order_dir'] ?? 'asc';

function toggle_order_dir($order_key) {
    global $order, $current_dir;
    return ($order_key === $order && $current_dir === 'asc') ? 'desc' : 'asc';
}
?>

<!DOCTYPE html>
<html lang="en">
<?php require("assets/includes/head.html") ?>
<title>Codex - Warpon Prime</title>
        <?php include("assets/includes/header.php"); ?>

        <main>
            <div class="orderBar">
                <a class="orderBarText" href="<?php echo build_url(['order' => 'n', 'order_dir' => toggle_order_dir('n')]); ?>">
                    Name
                </a>
                <h1 class="orderBarCut">|</h1>
                <a class="orderBarText" href="<?php echo build_url(['order' => 'rd', 'order_dir' => toggle_order_dir('rd')]) ?>">
                    Release Order
                </a>
                <h1 class="orderBarCut">|</h1>
                <a class="orderBarText" href="<?php echo build_url(['order' => 'rot', 'order_dir' => toggle_order_dir('rot')]) ?>">
                    Release Order by Type
                </a>
            </div>

            <form action="<?php echo build_url(); ?>" method="get" class="searchForm">
                <label for="searchId">Search for Equipment</label>
                <input id="searchId" type="text" name="search" value="<?php echo htmlspecialchars(trim($search)); ?>" />
                <input type="Submit" value="Search" />
            </form>

            <?php
                $allowed_tables = ['warframes', 'primaries', 'secondaries', 'melees'];
                if (!in_array($t, $allowed_tables)) {
                    $t = 'warframes';
                }

                $order_dir = strtoupper($_GET['order_dir'] ?? 'asc');

                if (!in_array($order_dir, ['ASC', 'DESC'])) {
                    $order_dir = 'ASC';
                }

                $query = "SELECT * FROM `$t` WHERE MASTERY <= " . ($user_data['MASTERY_RANK'] / 100) . " OR CREATOR = '" . $user_data['USERNAME'] . "'";

                if (!empty($search)) {
                    $search_safe = mysqli_real_escape_string($dbc, $search);
                    $query .= " AND NAME LIKE '%" . $search_safe . "%'";
                }

                $query .= " ORDER BY $sort $order_dir";

                $result = mysqli_query($dbc, $query);

                echo '<div class="codexList">';
                $t_safe = $t ?? 'warframes';
                if (mysqli_num_rows($result) > 0) {
                    while ($row = mysqli_fetch_assoc($result)) {
                        $href = ($t_safe === 'warframes') 
                            ? "view-warframe.php?equip_id=" . $row['ID'] 
                            : "view-weapon.php?equip_id=" . $row['ID'];

                        echo '<a class="codexItem" ' . 
                            (!empty($row['IMAGE_LINK']) ? 'style="background-image: url(' . $row['IMAGE_LINK'] . ')" ' : '') . 
                            "href='$href'>";
                        echo '<h3>' . htmlspecialchars($row['NAME']) . '</h3>';
                        echo '</a>';
                    }
                } else {
                    echo '<p>No entries found in ' . htmlspecialchars($t_safe) . '.</p>';
                }
                echo '</div>';
            ?>
        </main>

        <?php include("assets/includes/footer.html"); ?>
    </body>
</html>